<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Agenda;
use App\AgendaDetail;

class AgendaController extends Controller
{
    public function index(Request $request) {
        $agendas = Agenda::orderby('created_at','desc')->get();

        return view('backend.agendas.index', compact('agendas'));
    }

    public function create()
    {
        return view('backend.agendas.create');
    }

    public function store(Request $request)
    {
        $agenda = new Agenda;
        $agenda->date = $request->date;
        $agenda->title = $request->title;

        if($agenda->save()){
            flash(translate('Agenda has been inserted successfully'))->success();
            return redirect()->route('agendas.edit', encrypt($agenda->id));
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $agenda = Agenda::findOrFail(decrypt($id));
        $agendaDetails = AgendaDetail::where('agenda_id',decrypt($id))->orderby('created_at','desc')->get();
        return view('backend.agendas.edit', compact('agenda','agendaDetails'));
    }

    public function update(Request $request, $id)
    {
        $agenda = Agenda::findOrFail($id);
        $agenda->date = $request->date;
        $agenda->title = $request->title;

        if($agenda->save()){
            flash(translate('Agenda has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(Agenda::destroy($id)){
            flash(translate('Agenda has been deleted successfully'))->success();
            return redirect()->route('agendas.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }
}
