<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Agenda;
use App\AgendaDetail;

class AgendaDetailsController extends Controller
{
    public function create($id)
    {
        $agenda_id = decrypt($id);
        return view('backend.agendas_details.create', compact('agenda_id'));
    }

    public function store(Request $request)
    {
        $agenda_details = new AgendaDetail;
        $agenda_details->agenda_id = $request->agenda_id;
        $agenda_details->time = $request->time;
        $agenda_details->event = $request->event;
        $agenda_details->venue = $request->venue;
        $agenda_details->dress_code = $request->dress_code;
        $agenda_details->sponsor = $request->sponsor;

        if($agenda_details->save()){
            flash(translate('Agenda Event has been inserted successfully'))->success();
            // return redirect()->route('agendas_details.edit', encrypt($agenda_details->id));
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $agendaDetails = AgendaDetail::findOrFail(decrypt($id));
        return view('backend.agendas_details.edit', compact('agendaDetails'));
    }

    public function update(Request $request, $id)
    {
        $agenda_details = AgendaDetail::findOrFail($id);
        $agenda_details->time = $request->time;
        $agenda_details->event = $request->event;
        $agenda_details->venue = $request->venue;
        $agenda_details->dress_code = $request->dress_code;
        $agenda_details->sponsor = $request->sponsor;

        if($agenda_details->save()){
            flash(translate('Agenda Event has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(AgendaDetail::destroy($id)){
            flash(translate('Agenda Event has been deleted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }
}
