<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Neutrality;

class NeutralityController extends Controller
{
    public function index(Request $request) {
        $neutralities = Neutrality::select('id','name','published','created_at')->orderby('created_at','desc')->get();

        return view('backend.neutralities.index', compact('neutralities'));
    }

    public function create()
    {
        return view('backend.neutralities.create');
    }       

    public function store(Request $request)
    {
        $neutrality = new Neutrality;
        $neutrality->name = $request->name;

        if($neutrality->save()){
            flash(translate('neutrality has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $neutrality = Neutrality::findOrFail(decrypt($id));
        return view('backend.neutralities.edit', compact('neutrality'));
    }

    public function update(Request $request, $id)
    {
        $neutrality = Neutrality::findOrFail($id);
        $neutrality->name = $request->name;
       
        if($neutrality->save()){
            flash(translate('Neutrality has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(Neutrality::destroy($id)){
            flash(translate('Neutrality has been deleted successfully'))->success();
            return redirect()->route('neutralities.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function published(Request $request) {
        $neutrality = Neutrality::find($request->id);
        $neutrality->published = $request->published;
        if($neutrality->save()){
            return '1';
        }
        else {
            return '0';
        }
    }
}
