<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Review;
use Auth;
use DB;
use Illuminate\Support\Str;
use Image;

class ReviewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $reviews = Review::select('id','name','photo','published')->get();
        return view('reviews.index', compact('reviews'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $reviews = Review::select('id','name','classes','photo')->get();
        return view('reviews.create', compact('reviews'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $review = new Review;
        $review->name = $request->name;
        $review->classes = $request->classes;

        if($request->hasFile('photo')){
            $imageName1 = date('d-m-Y-H-i').'-'.Str::random(8).'.webp';
            $review->photo = 'uploads/reviews/'.$imageName1;
            $image1 = $request->file('photo');
            $destinationPath1 = public_path().'/'.$review->photo;

            $img1 = Image::make($image1->getRealPath());
            $img1->save($destinationPath1,60);

        }

        if($review->save()){
            flash(translate('Review has been submitted successfully'))->success();
            return back();
        }

        flash(translate('Something went wrong'))->error();
        return back();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $review = Review::findOrFail(decrypt($id));
        return view('reviews.edit', compact('review'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $review = new Review;
        $review->name = $request->name;
        $review->classes = $request->classes;

        if($request->hasFile('photo')){
            $imageName1 = date('d-m-Y-H-i').'-'.Str::random(8).'.webp';
            $review->photo = 'uploads/reviews/'.$imageName1;
            $image1 = $request->file('photo');
            $destinationPath1 = public_path().'/'.$review->photo;

            $img1 = Image::make($image1->getRealPath());
            $img1->save($destinationPath1,60);

        }

        if($review->save()){
            flash(translate('Review has been updated successfully'))->success();
            return back();
        }

        flash(translate('Something went wrong'))->error();
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $review = Review::findOrFail($id);
        if(Review::destroy($id)){
            if($review->photo != null){
                if($review->photo != null || $review->photo != ''){
                    unlink(public_path($review->photo));
                }
            }
            flash(translate('Review has been deleted successfully'))->success();
            return redirect()->route('testimonials.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function updatePublished(Request $request)
    {
        $review = Review::findOrFail($request->id);
        $review->published = $request->published;
        if($review->save()){
            return 1;
        }
        return 0;
    }
}
