<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Service;

class ServiceController extends Controller
{
    public function index(Request $request) {
        $services = Service::select('id','name','published','order_number','created_at')->orderby('created_at','desc')->get();

        return view('backend.services.index', compact('services'));
    }

    public function create()
    {
        return view('backend.services.create');
    }

    public function store(Request $request)
    {
        $service = new Service;
        $service->name = $request->name;
        $service->order_number = $request->order_number;

        if($service->save()){
            flash(translate('Service has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $service = Service::findOrFail(decrypt($id));
        return view('backend.services.edit', compact('service'));
    }

    public function update(Request $request, $id)
    {
        $service = Service::findOrFail($id);
        $service->name = $request->name;
        $service->order_number = $request->order_number;
       
        if($service->save()){
            flash(translate('Service has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(Service::destroy($id)){
            flash(translate('Service has been deleted successfully'))->success();
            return redirect()->route('services.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function published(Request $request) {
        $service = Service::find($request->id);
        $service->published = $request->published;
        if($service->save()){
            return '1';
        }
        else {
            return '0';
        }
    }
}
