<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Software;

class SoftwareController extends Controller
{
    public function index(Request $request) {
        $softwares = Software::select('id','name','published','order_number','created_at')->orderby('created_at','desc')->get();

        return view('backend.softwares.index', compact('softwares'));
    }

    public function create()
    {
        return view('backend.softwares.create');
    }

    public function store(Request $request)
    {
        $software = new Software;
        $software->name = $request->name;
        $software->order_number = $request->order_number;

        if($software->save()){
            flash(translate('Software has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $software = Software::findOrFail(decrypt($id));
        return view('backend.softwares.edit', compact('software'));
    }

    public function update(Request $request, $id)
    {
        $software = Software::findOrFail($id);
        $software->name = $request->name;
        $software->order_number = $request->order_number;
       
        if($software->save()){
            flash(translate('Software has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id)
    {
        if(Software::destroy($id)){
            flash(translate('Software has been deleted successfully'))->success();
            return redirect()->route('softwares.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function published(Request $request) {
        $software = Software::find($request->id);
        $software->published = $request->published;
        if($software->save()){
            return '1';
        }
        else {
            return '0';
        }
    }
}
