<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Brand;
use Illuminate\Support\Str;
use Image;

class SponsorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
        $sponsors = Brand::select('id','sponsorship_type','name','logo','column_size','height','image_class','created_at')->orderby('created_at','desc')->get();

        return view('sponsors.index', compact('sponsors'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('sponsors.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $sponsor = new Brand;
        $sponsor->name = $request->name;
        $sponsor->sponsorship_type = $request->sponsorship_type;
        $sponsor->website_link = $request->website_link;
        $sponsor->column_size = $request->column_size;
        $sponsor->height = $request->height;
        $sponsor->image_class = $request->image_class;
        $sponsor->sponsorship_name_css = $request->sponsorship_name_css;

        if($request->hasFile('logo')){
            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $sponsor->logo = 'uploads/brands/'.$imageName;

            $image = $request->file('logo');
            $destinationPath = public_path().'/'.$sponsor->logo;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,60);
        }

        if($sponsor->save()){
            flash(translate('Sponsor has been inserted successfully'))->success();
            return redirect()->route('sponsors.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id)
    {
        $sponsor = Brand::findOrFail(decrypt($id));
        return view('sponsors.edit', compact('sponsor'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $sponsor = Brand::findOrFail($id);
        $sponsor->name = $request->name;
        $sponsor->sponsorship_type = $request->sponsorship_type;
        $sponsor->website_link = $request->website_link;
        $sponsor->column_size = $request->column_size;
        $sponsor->height = $request->height;
        $sponsor->image_class = $request->image_class;
        $sponsor->sponsorship_name_css = $request->sponsorship_name_css;
       
        if($request->hasFile('logo')){
            if($sponsor->logo != null || $sponsor->logo != ''){
                unlink(public_path($sponsor->logo));
            }
            $imageName = date('d-m-Y-H-i').'-'.Str::random(5).'.webp';
            $sponsor->logo = 'uploads/brands/'.$imageName;

            $image = $request->file('logo');
            $destinationPath = public_path().'/'.$sponsor->logo;
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath,60);
        }

        if($sponsor->save()){
            flash(translate('Sponsor has been updated successfully'))->success();
            return redirect()->route('sponsors.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $sponsor = Brand::findOrFail($id);
        if(Brand::destroy($id)){
            if($sponsor->logo != null){
                if($sponsor->logo != null || $sponsor->logo != ''){
                    unlink(public_path($sponsor->logo));
                }
            }
            flash(translate('Sponsor has been deleted successfully'))->success();
            return redirect()->route('sponsors.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }
}
