<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Sponsorship;

class SponsorshipController extends Controller
{
    
    public function index(Request $request) {
        $sponsorships = Sponsorship::select('id','name','price','published','slots','is_sold_out','type','order_number','created_at')->orderby('order_number','desc')->get();

        return view('backend.sponsorships.index', compact('sponsorships'));
    }

    public function create() {
        $sponsor = Sponsorship::where('published',1)->orderby('order_number','desc')->first();
        return view('backend.sponsorships.create', compact('sponsor'));
    }

    public function store(Request $request) {
        $sponsor = new Sponsorship;
        $sponsor->name = $request->name;
        $sponsor->price = $request->price;
        $sponsor->slots = $request->slots;
        $sponsor->inclusions = $request->inclusions;
        $sponsor->type = $request->type;
        $sponsor->order_number = $request->order_number;

        $sponsor->total_free_conference_pass = $request->total_free_conference_pass;

        if($sponsor->save()){
            flash(translate('Sponsorship has been inserted successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function edit($id) {
        $sponsor = Sponsorship::findOrFail(decrypt($id));
        return view('backend.sponsorships.edit', compact('sponsor'));
    }

    public function update(Request $request, $id) {

        $sponsor = Sponsorship::findOrFail($id);
        $sponsor->name = $request->name;
        $sponsor->price = $request->price;
        $sponsor->slots = $request->slots;
        $sponsor->inclusions = $request->inclusions;
        $sponsor->type = $request->type;
        $sponsor->order_number = $request->order_number;

        $sponsor->total_free_conference_pass = $request->total_free_conference_pass;
       
        if($sponsor->save()){
            flash(translate('Sponsorship has been updated successfully'))->success();
            return back();
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function destroy($id) {
        if(Sponsorship::destroy($id)){
            flash(translate('Sponsorship has been deleted successfully'))->success();
            return redirect()->route('sponsorships.index');
        } else {
            flash(translate('Something went wrong'))->error();
            return back();
        }
    }

    public function published(Request $request) {
        $sponsor = Sponsorship::find($request->id);
        $sponsor->published = $request->published;
        if($sponsor->save()){
            return '1';
        }
        else {
            return '0';
        }
    }

    public function sold_out(Request $request) {
        $sponsor = Sponsorship::find($request->id);
        $sponsor->is_sold_out = $request->soldOut;
        if($sponsor->save()){
            return '1';
        }
        else {
            return '0';
        }
    }
}
