<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Registration extends Model
{
    protected $fillable = [
        'company', 'firstname', 'lastname', 'shirt', 'position', 'email', 'mobile', 'telephone', 'website', 'iata', 'address', 'city', 'country'
    ];

    public function dietaries()
    {
        return $this->hasMany('App\RegDietary', 'reg_id', 'id');
    }
    public function specialization()
    {
        return $this->belongsToMany('App\Specialization', 'reg_specializations', 'reg_id', 'specialization');
    }
    public function services()
    {
        return $this->belongsToMany('App\Service', 'reg_services', 'reg_id', 'service');
    }
    public function neutralities()
    {
        return $this->belongsToMany('App\Neutrality', 'reg_neutralities', 'reg_id', 'neutrality');
    }
    public function software()
    {
        return $this->belongsToMany('App\Software', 'reg_softwares', 'reg_id', 'software');
    }
    public function sponsorship()
    {
        return $this->belongsToMany('App\Sponsorship', 'reg_sponsorships', 'reg_id', 'sponsorship');
    }
    public function advertisement()
    {
        return $this->belongsToMany('App\Advertisement', 'reg_advertisements', 'reg_id', 'advertisement');
    }
    public function double()
    {
        return $this->hasMany('App\Registration', 'id', 'colleague_id');
    }
}