@extends('layouts.app')

@section('content')

<div class="col-lg-10 col-lg-offset-1 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Update Agenda Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('agendas.update', $agenda->id) }}" method="POST" enctype="multipart/form-data">
            <input name="_method" type="hidden" value="PUT">
        	@csrf
            <div class="panel-body">

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="date">{{translate('Date')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('e.g., DAY 1 | SUNDAY, MARCH 12, 2023')}}" id="date" name="date" class="form-control" required value="{{ $agenda->date }}">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="title">{{translate('Title')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('e.g., Registration and Welcome Cocktail Reception')}}" id="title" name="title" class="form-control" required value="{{ $agenda->title }}">
                    </div>
                </div>
                
            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('agendas.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('agenda_details.create', encrypt($agenda->id))}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Event')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Agenda Events')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Time') }}</th>
                    <th>{{ translate('Event') }}</th>
                    <th>{{ translate('Venue') }}</th>
                    <th>{{ translate('Dress Code') }}</th>
                    <th>{{ translate('Sponsor') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($agendaDetails as $key => $agendaDetail)
                    <tr>
                        <td>{{ $agendaDetail->time }}</td>
                        <td>{!! $agendaDetail->event !!}</td>
                        <td>{{ $agendaDetail->venue }}</td>
                        <td>{{ $agendaDetail->dress_code }}</td>
                        <td>{{ $agendaDetail->sponsor }}</td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($agendaDetail->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('agenda_details.edit', encrypt($agendaDetail->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('agenda_details.destroy', $agendaDetail->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection

@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 6 }
                ],
                order: [[5, 'asc']],
            } );
        }
    } );
</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection