@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Agenda Banners and Title Section')}}</h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="{{ route('banners.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="agenda_page_title">{{translate('Title')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Title')}}" id="agenda_page_title" name="agenda_page_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'agenda_page_title')->first()->value }}">
                        </div>
                    </div>

                    @if(isset(\App\BusinessSetting::where('type', 'banners_agenda_desktop')->first()->value))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_agenda_desktop')->first()->value) }}" alt="Display Picture">
                        </div>
                    </div>
                    @endif
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_agenda_desktop">{{translate('Desktop Banner')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_agenda_desktop" name="banners_agenda_desktop" class="form-control">
                        </div>
                    </div>

                    @if(isset(\App\BusinessSetting::where('type', 'banners_agenda_mobile')->first()->value))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_agenda_mobile')->first()->value) }}" alt="Display Picture">
                        </div>
                    </div>
                    @endif
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_agenda_mobile">{{translate('Mobile Banner')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_agenda_mobile" name="banners_agenda_mobile" class="form-control">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-success" type="submit">{{translate('Update Banners and Title')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<br>

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('agendas.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Agenda')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Agendas')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Date') }}</th>
                    <th>{{ translate('Title') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($agendas as $key => $agenda)
                    <tr>
                        <td>{{ $agenda->date }}</td>
                        <td>{{ $agenda->title }}</td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($agenda->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('agendas.edit', encrypt($agenda->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('agendas.destroy', $agenda->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 3 }
                ],
                order: [[0, 'desc']],
            } );
        }
    } );
</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection