@extends('layouts.app')

@section('content')

<div class="col-lg-10 col-lg-offset-1 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Update Agenda Events Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('agenda_details.update', $agendaDetails->id) }}" method="POST" enctype="multipart/form-data">
            <input name="_method" type="hidden" value="PUT">
        	@csrf
            <div class="panel-body">

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="time">{{translate('Time')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('e.g., 07:00 am - 07:15 am')}}" id="time" name="time" class="form-control" required value="{{ $agendaDetails->time }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="event">{{translate('Event')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <textarea class="form-control simple-editor" name="event" required>{{ $agendaDetails->event }}</textarea>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="venue">{{translate('Venue')}}</label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('e.g., Hotel restaurant')}}" id="venue" name="venue" class="form-control" value="{{ $agendaDetails->venue }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="dress_code">{{translate('Dress Code')}}</label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('e.g., Smart casual')}}" id="dress_code" name="dress_code" class="form-control" value="{{ $agendaDetails->dress_code }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="sponsor">{{translate('Sponsor')}}</label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Sponsor')}}" id="sponsor" name="sponsor" class="form-control" value="{{ $agendaDetails->sponsor }}">
                    </div>
                </div>
                
            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('agendas.edit', encrypt($agendaDetails->agenda_id)) }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection