@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Benefit Title and Description Section')}}</h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="{{ route('banners.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="benefit_section_title">{{translate('Title')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Title')}}" id="benefit_section_title" name="benefit_section_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'benefit_section_title')->first()->value }}">
                        </div>
                    </div>

                    <div class="form-group">
                            <label class="col-sm-2 control-label" for="benefit_section_description">{{translate('Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Description')}}" id="benefit_section_description" name="benefit_section_description" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'benefit_section_description')->first()->value }}">
                            </div>
                        </div>

                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-success" type="submit">{{translate('Update Title and Description')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<br>

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('benefits.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Benefit')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Benefits')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Order Number') }}</th>
                    <th>{{ translate('Icon') }}</th>
                    <th>{{ translate('Details') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($benefits as $key => $benefit)
                    <tr>
                        <td>{{ $benefit->order_number }}</td>
                        <td><img width="100" src="{{ my_asset($benefit->icons) }}" alt="icons"></td>
                        <td>{{ $benefit->details }}</td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($benefit->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('benefits.edit', encrypt($benefit->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('benefits.destroy', $benefit->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 1 },
                    { orderable: false, targets: 4 }
                ],
                order: [[3, 'desc']],
            } );
        }
    } );
</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection