@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Common Newsletter Section')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('commons_newsletter.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        @if(isset(\App\BusinessSetting::where('type', 'common_newsletter_background_image')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'common_newsletter_background_image')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="common_newsletter_background_image">{{translate('Background Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="common_newsletter_background_image" name="common_newsletter_background_image" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="common_newsletter_title">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="common_newsletter_title" name="common_newsletter_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'common_newsletter_title')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="common_newsletter_description">{{translate('Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control simple-editor" name="common_newsletter_description" required>{{ \App\BusinessSetting::where('type', 'common_newsletter_description')->first()->value }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="common_newsletter_button_name">{{translate('Button Name')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Name')}}" id="common_newsletter_button_name" name="common_newsletter_button_name" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'common_newsletter_button_name')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="common_newsletter_button_link">{{translate('Button Modal')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control" rows="12" name="common_newsletter_button_link" required>{{ \App\BusinessSetting::where('type', 'common_newsletter_button_link')->first()->value }}</textarea>
                                <!-- <input type="text" placeholder="{{translate('Button Link')}}" id="common_newsletter_button_link" name="common_newsletter_button_link" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'common_newsletter_button_link')->first()->value }}"> -->
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="common_newsletter_button_script">{{translate('Button Script')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control" rows="12" name="common_newsletter_button_script" required>{{ \App\BusinessSetting::where('type', 'common_newsletter_button_script')->first()->value }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="common_newsletter_button_bg_color">{{translate('Button Background Color')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Background Color')}}" id="common_newsletter_button_bg_color" name="common_newsletter_button_bg_color" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'common_newsletter_button_bg_color')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="common_newsletter_button_text_color">{{translate('Button Text Color')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Button Text Color')}}" id="common_newsletter_button_text_color" name="common_newsletter_button_text_color" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'common_newsletter_button_text_color')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
