@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Covid Info Banners')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('banners.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        @if(isset(\App\BusinessSetting::where('type', 'banners_covid_info_desktop')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_covid_info_desktop')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_covid_info_desktop">{{translate('Desktop Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_covid_info_desktop" name="banners_covid_info_desktop" class="form-control">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'banners_covid_info_mobile')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_covid_info_mobile')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_covid_info_mobile">{{translate('Mobile Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_covid_info_mobile" name="banners_covid_info_mobile" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="covid_info_title">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="covid_info_title" name="covid_info_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'covid_info_title')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="covid_info_descriptions">{{translate('Description')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <textarea class="form-control editor" name="covid_info_descriptions" required>{{ \App\BusinessSetting::where('type', 'covid_info_descriptions')->first()->value }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
