@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Downloadables Section')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('downloadable_section.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="downloadables_section_title">{{translate('Title')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Title')}}" id="downloadables_section_title" name="downloadables_section_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'downloadables_section_title')->first()->value }}">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'downloadables_section_image')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'downloadables_section_image')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="downloadables_section_image">{{translate('Display Image')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="downloadables_section_image" name="downloadables_section_image" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="downloadables_section_dl_list_button_name">{{translate('Button Name')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Name')}}" id="downloadables_section_dl_list_button_name" name="downloadables_section_dl_list_button_name" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'downloadables_section_dl_list_button_name')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="downloadables_section_dl_list_button_link">{{translate('Button Link')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Link')}}" id="downloadables_section_dl_list_button_link" name="downloadables_section_dl_list_button_link" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'downloadables_section_dl_list_button_link')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="downloadables_section_dl_list_button_bg_color">{{translate('Button Background Color')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Background Color')}}" id="downloadables_section_dl_list_button_bg_color" name="downloadables_section_dl_list_button_bg_color" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'downloadables_section_dl_list_button_bg_color')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="downloadables_section_dl_list_button_text_color">{{translate('Button Text Color')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="text" placeholder="{{translate('Button Button Text Color')}}" id="downloadables_section_dl_list_button_text_color" name="downloadables_section_dl_list_button_text_color" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'downloadables_section_dl_list_button_text_color')->first()->value }}">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
