@extends('layouts.app')

@section('content')

<div class="col-lg-10 col-lg-offset-1 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Email Inquiry from ')}} {{ $email->name }}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" method="POST" enctype="multipart/form-data">
        	@csrf
            <div class="panel-body">

                <div class="form-group">
                    <label class="col-sm-6" for="company_name"><strong>{{translate('Company Name')}}:</strong> {{ $email->company_name }}</label>
                    <label class="col-sm-6" for="name"><strong>{{translate('Full Name')}}:</strong> {{ $email->name }}</label>
                </div>
                <div class="form-group">
                    <label class="col-sm-6" for="email"><strong>{{translate('Email')}}:</strong> <a href="mailto:{{ $email->email }}">{{ $email->email }}</a></label>
                    <label class="col-sm-6" for="phone_number"><strong>{{translate('Phone Number')}}:</strong> {{ $email->phone_number }}</label>
                </div>
                <div class="form-group">
                    <label class="col-sm-6" for="mobile_number"><strong>{{translate('Mobile Number')}}:</strong> {{ $email->mobile_number }}</label>
                    <label class="col-sm-6" for="website_url"><strong>{{translate('Website URL')}}:</strong> <a href="{{ $email->website_url }}">{{ $email->website_url }}</a></label>
                </div>
                <div class="form-group">
                    <label class="col-sm-12" for="message"><strong>{{translate('Message')}}:</strong></label>
                    <label class="col-sm-12" for="message">{{ $email->message }}</label>
                </div>
                
            </div>
            <div class="panel-footer text-right">
                <a href="{{ route('inquiry.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection