@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Meeting Cost Banners and Title Section')}}</h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="{{ route('banners.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="meeting_cost_page_title">{{translate('Title')}} </label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Title')}}" id="meeting_cost_page_title" name="meeting_cost_page_title" class="form-control" value="{{ \App\BusinessSetting::where('type', 'meeting_cost_page_title')->first()->value }}">
                        </div>
                    </div>

                    @if(isset(\App\BusinessSetting::where('type', 'banners_meeting_cost_desktop')->first()->value))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_meeting_cost_desktop')->first()->value) }}" alt="Display Picture">
                        </div>
                    </div>
                    @endif
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_meeting_cost_desktop">{{translate('Desktop Banner')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_meeting_cost_desktop" name="banners_meeting_cost_desktop" class="form-control">
                        </div>
                    </div>

                    @if(isset(\App\BusinessSetting::where('type', 'banners_meeting_cost_mobile')->first()->value))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_meeting_cost_mobile')->first()->value) }}" alt="Display Picture">
                        </div>
                    </div>
                    @endif
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_meeting_cost_mobile">{{translate('Mobile Banner')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_meeting_cost_mobile" name="banners_meeting_cost_mobile" class="form-control">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-success" type="submit">{{translate('Update Banners and Title')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<br>

<!-- <div class="row">
    <div class="col-sm-12">
        <a href="{{ route('meeting_costs.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Meeting Cost')}}</a>
    </div>
</div>

<br> -->

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Meeting Costs')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Title') }}</th>
                    <th>{{ translate('Early Bird Rate Price') }}</th>
                    <th>{{ translate('Early Bird Valid Until') }}</th>
                    <th>{{ translate('Regular Rate Price') }}</th>
                    <th>{{ translate('Is VIP') }}</th>
                    <th>{{ translate('Is Sold Out') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($meetingCosts as $key => $meetingCost)
                    <tr>
                        <td>{{ $meetingCost->title }}</td>
                        <td>{{ $meetingCost->early_bird_rate_price }}</td>
                        <td>{{ $meetingCost->early_bird_rate_date }}</td>
                        <td>{{ $meetingCost->regular_rate_price }}</td>
                        <td>
                            <label class="switch">
                            <input onchange="update_is_vip(this)" value="{{ $meetingCost->id }}" type="checkbox" <?php if($meetingCost->vip == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td>
                            <label class="switch">
                            <input onchange="update_is_sold_out(this)" value="{{ $meetingCost->id }}" type="checkbox" <?php if($meetingCost->is_sold_out == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($meetingCost->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('meeting_costs.edit', encrypt($meetingCost->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('meeting_costs.destroy', $meetingCost->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 4 },
                    { orderable: false, targets: 6 }
                ],
                order: [[5, 'desc']],
            } );
        }
    } );

    function update_is_vip(el){
        if(el.checked){
            var published = 1;
        } else {
            var published = 0;
        }
        $.post('{{ route('meeting_costs.is_vip') }}', {_token:'{{ csrf_token() }}', id:el.value, published:published}, function(data){
            if(data == 1){
                showAlert('success', 'VIP updated successfully');
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }

    function update_is_sold_out(el){
        if(el.checked){
            var status = 1;
        } else {
            var status = 0;
        }
        $.post('{{ route('meeting_costs.is_sold_out') }}', {_token:'{{ csrf_token() }}', id:el.value, status:status}, function(data){
            if(data == 1){
                showAlert('success', 'Sold out status updated successfully');
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }
</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection