@extends('layouts.app')

@section('content')

<div class="panel pad-btm-34">
    <div class="panel-heading">
        <h3 class="panel-title">{{__('Slider Information')}}</h3>
    </div>

    <form class="form-horizontal" action="{{ route('sliders.update', $slider->id) }}" method="POST" enctype="multipart/form-data">
        <input name="_method" type="hidden" value="PUT">
        @csrf
        <div class="panel-body">
            <div class="form-group">
                <label class="col-sm-3" for="order">{{translate('Order')}}</label>
                <div class="col-sm-9">
                    <input type="number" min="0" step="1" placeholder="{{__('Order')}}" name="order" value="{{ $slider->orders }}" class="form-control" required>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-3">
                    <label class="control-label">{{translate('Slider Desktop Images1')}}</label>
                    <!-- <strong>(1920px*1280px)</strong> -->
                </div>
                <div class="col-sm-9">
                    <div id="photo">
                        @if(isset($slider->photo))
                            <div class="col-md-4 col-sm-4 col-xs-6">
                                <div class="img-upload-preview">
                                    <img loading="lazy"  src="{{ my_asset($slider->photo) }}" alt="" class="img-responsive">
                                    <input type="hidden" name="previous_photo" value="{{ $slider->photo }}">
                                    <button type="button" class="btn btn-danger close-btn remove-files"><i class="fa fa-times"></i></button>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-sm-3">
                 <!--   <label class="control-label">{{translate('Slider Mobile Images2')}} <span class="red">*</span></label>
                        // <strong>(1920px*1280px)</strong>  -->
                <div class="col-sm-9">
                    <!--<div id="mobile_photo">  

                    </div>  -->
                </div>
            </div>
        </div>
        <div class="panel-footer text-right">
            <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
            <a href="{{ route('sliders.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
        </div>
    </form>
</div>

@endsection

@section('script')

<script type="text/javascript">
    $(document).ready(function(){
        $('.remove-files').on('click', function(){
            $(this).parents(".col-md-4").remove();
        });

        $("#photo").spartanMultiImagePicker({
            fieldName:        'photo',
            maxCount:         1,
            rowHeight:        '200px',
            groupClassName:   'col-md-4 col-sm-9 col-xs-6',
            maxFileSize:      '',
            dropFileLabel : "Drop Here",
            onExtensionErr : function(index, file){
                console.log(index, file,  'extension err');
                alert('Please only input png or jpg type file')
            },
            onSizeErr : function(index, file){
                console.log(index, file,  'file size too big');
                alert('File size too big');
            }
        });
        $("#mobile_photo").spartanMultiImagePicker({
            fieldName:        'mobile_photo',
            maxCount:         1,
            rowHeight:        '200px',
            groupClassName:   'col-md-4 col-sm-9 col-xs-6',
            maxFileSize:      '',
            dropFileLabel : "Drop Here",
            onExtensionErr : function(index, file){
                console.log(index, file,  'extension err');
                alert('Please only input png or jpg type file')
            },
            onSizeErr : function(index, file){
                console.log(index, file,  'file size too big');
                alert('File size too big');
            }
        });
    });

</script>

@endsection
