@extends('layouts.app')

@section('content')

<div class="col-lg-12 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Sponsor Per Sponsorships Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('sponsors.store') }}" method="POST" enctype="multipart/form-data">
        	@csrf
            <div class="panel-body">

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="logo">{{translate('Logo')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="file" id="logo" name="logo" class="form-control" required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="website_link">{{translate('Website Link')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Website Link')}}" id="website_link" name="website_link" class="form-control" required>
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="sponsorship_id">{{translate('Sponsorship')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <select name="sponsorship_id" id="sponsorship_id" class="form-control demo-select2-placeholder" required>
                            @foreach($sponsorships as $key => $sponsorship)
                                <option value="{{ $sponsorship->id }}">{{ $sponsorship->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('sponsors.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection
