@extends('layouts.app')

@section('content')

<div class="col-lg-10 col-lg-offset-1 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Update Sponsor Per Sponsorships Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('sponsors.update', $sponsor->id) }}" method="POST" enctype="multipart/form-data">
            <input name="_method" type="hidden" value="PUT">
        	@csrf
            <div class="panel-body">

                @if(isset($sponsor->logo))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 200px !important; height: 100% !important;" src="{{ my_asset($sponsor->logo) }}" alt="Icons">
                        </div>
                    </div>
                @endif

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="logo">{{translate('Logo')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="file" id="logo" name="logo" class="form-control">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="website_link">{{translate('Website Link')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Website Link')}}" id="website_link" name="website_link" class="form-control" required value="{{ $sponsor->website_link }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="sponsorship_id">{{translate('Sponsorship')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <select name="sponsorship_id" id="sponsorship_id" class="form-control demo-select2-placeholder" required>
                            @foreach($sponsorships as $key => $sponsorship)
                                <option value="{{ $sponsorship->id }}" <?php if($sponsor->sponsorship_id == $sponsorship->id) echo "selected" ?>>{{ $sponsorship->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('sponsors.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection