@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Sponsorships Banners')}}</h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="{{ route('banners.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    @if(isset(\App\BusinessSetting::where('type', 'banners_sponsorship_desktop')->first()->value))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_sponsorship_desktop')->first()->value) }}" alt="Display Picture">
                        </div>
                    </div>
                    @endif
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_sponsorship_desktop">{{translate('Desktop Banner')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_sponsorship_desktop" name="banners_sponsorship_desktop" class="form-control">
                        </div>
                    </div>

                    @if(isset(\App\BusinessSetting::where('type', 'banners_sponsorship_mobile')->first()->value))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_sponsorship_mobile')->first()->value) }}" alt="Display Picture">
                        </div>
                    </div>
                    @endif
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="banners_sponsorship_mobile">{{translate('Mobile Banner')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="file" id="banners_sponsorship_mobile" name="banners_sponsorship_mobile" class="form-control">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sponsorships_page_title">{{translate('Title')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Title')}}" id="sponsorships_page_title" name="sponsorships_page_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'sponsorships_page_title')->first()->value }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sponsorships_page_details">{{translate('Description')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <textarea class="form-control" rows="4" name="sponsorships_page_details" required>{{ \App\BusinessSetting::where('type', 'sponsorships_page_details')->first()->value }}</textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="sponsorships_page_whatsapp_number">{{translate('WhatsApp Number')}} </label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('WhatsApp Number')}}" id="sponsorships_page_whatsapp_number" name="sponsorships_page_whatsapp_number" class="form-control" value="{{ \App\BusinessSetting::where('type', 'sponsorships_page_whatsapp_number')->first()->value }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-success" type="submit">{{translate('Update Banners')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<br>

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('sponsorships.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Sponsorships')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Sponsorships')}}</h3>
    </div>
    <div class="panel-body">
        <table id="dt-selection" class="table table-striped table-bordered" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>{{ translate('Name') }}</th>
                    <th>{{ translate('Price') }}</th>
                    <th>{{ translate('Slots') }}</th>
                    <th>{{ translate('Type') }}</th>
                    <th>{{ translate('Order Number') }}</th>
                    <th>{{ translate('Published') }}</th>
                    <th>{{ translate('Is Sold Out?') }}</th>
                    <th>{{ translate('Created At') }}</th>
                    <th width="16%">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($sponsorships as $key => $sponsorship)
                    <tr>
                        <td>{{ $sponsorship->name }}</td>
                        <td>{{ $sponsorship->price }}</td>
                        <td>{{ $sponsorship->slots }}</td>
                        <td>{{ $sponsorship->type == 1 ? 'Premium' : 'Regular' }}</td>
                        <td>{{ $sponsorship->order_number }}</td>
                        <td>
                            <label class="switch">
                            <input onchange="published(this)" value="{{ $sponsorship->id }}" type="checkbox" <?php if($sponsorship->published == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td>
                            <label class="switch">
                            <input onchange="soldOut(this)" value="{{ $sponsorship->id }}" type="checkbox" <?php if($sponsorship->is_sold_out == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td>{{ date('F d, Y h:i:s A', strtotime($sponsorship->created_at)) }}</td>
                        <td>
                            <a class="btn btn-success" href="{{route('sponsorships.edit', encrypt($sponsorship->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('sponsorships.destroy', $sponsorship->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection
@section('script')

<script type="text/javascript">
    $(document).ready(function() {
        if ( $.fn.dataTable.isDataTable( '#dt-selection' ) ) {
            $('#dt-selection').DataTable( {
                destroy: true,
                "responsive": true,
                "language": {
                    "paginate": {
                    "previous": '<i class="demo-psi-arrow-left"></i>',
                    "next": '<i class="demo-psi-arrow-right"></i>'
                    }
                },
                columnDefs: [
                    { orderable: false, targets: 5 },
                    { orderable: false, targets: 6 },
                    { orderable: false, targets: 8 }
                ],
                order: [[7, 'desc']],
            } );
        }
    } );

    function published(el){
        if(el.checked){
            var published = 1;
        } else {
            var published = 0;
        }
        $.post('{{ route('sponsorships.published') }}', {_token:'{{ csrf_token() }}', id:el.value, published:published}, function(data){
            if(data == 1){
                showAlert('success', 'Sponsorship published status changed successfully');
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }

    function soldOut(el){
        if(el.checked){
            var soldOut = 1;
        } else {
            var soldOut = 0;
        }
        $.post('{{ route('sponsorships.sold_out') }}', {_token:'{{ csrf_token() }}', id:el.value, soldOut:soldOut}, function(data){
            if(data == 1){
                if(soldOut == 1){
                    showAlert('success', 'Sponsorship is sold out');
                } else {
                    showAlert('success', 'Sponsorship is still available');
                }
            }
            else{
                showAlert('danger', 'Something went wrong');
            }
        });
    }
    
</script>

@endsection

@section('css')

<style>
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0 0;
    }
</style>

@endsection