@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Visa Banners')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('banners.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        @if(isset(\App\BusinessSetting::where('type', 'banners_visa_desktop')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_visa_desktop')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_visa_desktop">{{translate('Desktop Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_visa_desktop" name="banners_visa_desktop" class="form-control">
                            </div>
                        </div>

                        @if(isset(\App\BusinessSetting::where('type', 'banners_visa_mobile')->first()->value))
                        <div class="form-group">
                            <div class="widget-image-box text-center">
                                <img loading="lazy" style="max-width: 100% !important; height: 100% !important;" src="{{ my_asset(\App\BusinessSetting::where('type', 'banners_visa_mobile')->first()->value) }}" alt="Display Picture">
                            </div>
                        </div>
                        @endif
                        <div class="form-group">
                            <label class="col-sm-2 control-label" for="banners_visa_mobile">{{translate('Mobile Banner')}} <span class="red">*</span></label>
                            <div class="col-sm-10">
                                <input type="file" id="banners_visa_mobile" name="banners_visa_mobile" class="form-control">
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
