@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-6">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Facebook Chat Setting')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('facebook_chat.update') }}" method="POST">
                        @csrf
                        <div class="form-group">
                            <div class="col-lg-3">
                                <label class="control-label">{{translate('Facebook Chat')}}</label>
                            </div>
                            <div class="col-lg-6">
                                <label class="switch">
                                    <input value="1" name="facebook_chat" type="checkbox" @if (\App\Models\BusinessSetting::where('type', 'facebook_chat')->first()->value == 1)
                                        checked
                                    @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="types[]" value="FACEBOOK_PAGE_ID">
                            <div class="col-lg-3">
                                <label class="control-label">{{translate('Facebook Page ID')}}</label>
                            </div>
                            <div class="col-lg-6">
                                <input type="text" class="form-control" name="FACEBOOK_PAGE_ID" value="{{ config('services.FACEBOOK_PAGE_ID') }}" placeholder="{{ translate('Facebook Page ID') }}" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-purple" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="panel bg-gray-light">
                <div class="panel-body">
                    <p class="h5">{{ translate('Please be carefull when you are configuring Facebook chat. For incorrect configuration you will not get messenger icon on your user-end site.') }}</p>
                    <ul class="list-group mar-no">
                        <li class="list-group-item text-dark">1. {{ translate('Login into your facebook page') }}</li>
                        <li class="list-group-item text-dark">2. {{ translate('Find the About option of your facebook page') }}.</li>
                        <li class="list-group-item text-dark">2. {{ translate('Select Page Transparency in the menu') }}.</li>
                        <li class="list-group-item text-dark">3. {{ translate('You can find the \“Page ID\”') }}.</li>
                        <li class="list-group-item text-dark">4. {{ translate('Go to this link https://www.facebook.com/settings?tab=advanced_messaging"') }}.</li>
                        <li class="list-group-item text-dark">5. {{ translate('Scroll down that page and you will get \"white listed domains\"') }}.</li>
                        <li class="list-group-item text-dark">6. {{ translate('Set your website domain name') }}.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection