@extends('layouts.app')

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-heading">
                    <h3 class="panel-title text-center">{{translate('Cookies Agreement')}}</h3>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal" action="{{ route('cookies.store') }}" method="POST">
                        @csrf
                        <div class="form-group">
                            <div class="col-lg-3">
                                <label class="control-label">{{translate('Show Cookies Agreement')}}</label>
                            </div>
                            <div class="col-lg-6">
                                <label class="switch">
                                    <input value="on" name="show_cookies_agreement" type="checkbox" @if (\App\BusinessSetting::where('type', 'show_cookies_agreement')->first()->value == "on")
                                        checked
                                    @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-3">
                                <label class="control-label">{{translate('Cookies Agreement Text')}}</label>
                            </div>
                            <div class="col-lg-6">
                                <textarea class="editor" name="cookies_agreement_text" required>{{ \App\BusinessSetting::where('type', 'cookies_agreement_text')->first()->value }}</textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12 text-right">
                                <button class="btn btn-purple" type="submit">{{translate('Save')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
