@extends('layouts.app')

@section('content')

    <div class="col-lg-10 col-lg-offset-1 pad-btm-34">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title">{{translate('General Settings')}}</h3>
            </div>

            <!--Horizontal Form-->
            <!--===================================================-->
            <form class="form-horizontal" action="{{ route('generalsettings.update',$generalsetting->id ) }}" method="POST" enctype="multipart/form-data">
            	@csrf
                <input type="hidden" name="_method" value="PATCH">
                <div class="panel-body">
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="name">{{translate('Site Name')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="name" name="name" value="{{ $generalsetting->site_name }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="url">{{translate('Site Url')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="url" name="url" value="{{ config('app.url') }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="site_year">{{translate('Site Year')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="site_year" name="site_year" value="{{ $generalsetting->site_year }}" class="form-control" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="conference_name">{{translate('Conference Name')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="conference_name" name="conference_name" value="{{ $generalsetting->conference_name }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="conference_hotel">{{translate('Conference Hotel')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="conference_hotel" name="conference_hotel" value="{{ $generalsetting->conference_hotel }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="conference_location">{{translate('Conference Location')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="conference_location" name="conference_location" value="{{ $generalsetting->conference_location }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="conference_date">{{translate('Conference Date')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="conference_date" name="conference_date" value="{{ $generalsetting->conference_date }}" class="form-control" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="name">{{translate('Footer About Us')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <textarea class="form-control" rows="6" name="description" required>{{ $generalsetting->description }}</textarea>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="contact_us">{{translate('Footer Contact Us')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <textarea class="form-control" rows="6" name="contact_us" required>{{ $generalsetting->contact_us }}</textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="email">{{translate('Email')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="email" name="email" value="{{ $generalsetting->email }}" class="form-control" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="youtube">{{translate('Youtube')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="youtube" name="youtube" value="{{ $generalsetting->youtube }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="facebook">{{translate('Facebook')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="facebook" name="facebook" value="{{ $generalsetting->facebook }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="instagram">{{translate('Instagram')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="instagram" name="instagram" value="{{ $generalsetting->instagram }}" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="linkedIn">{{translate('Linked In')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="linkedIn" name="linkedIn" value="{{ $generalsetting->linkedIn }}" class="form-control" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="frontend_color">{{translate('Theme Color')}} <span class="red">*</span></label>
                        <div class="col-sm-9">
                            <input type="text" id="frontend_color" name="frontend_color" value="{{ $generalsetting->frontend_color }}" class="form-control" required>
                        </div>
                    </div>
                    
                <div class="panel-footer text-right">
                    <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                </div>
            </form>
            <!--===================================================-->
            <!--End Horizontal Form-->

        </div>
    </div>

@endsection