@extends('layouts.app')

@section('content')

<div class="col-lg-12 pad-btm-34">
    <div class="panel">
        <div class="panel-heading">
            <h3 class="panel-title">{{translate('Client Information')}}</h3>
        </div>

        <!--Horizontal Form-->
        <!--===================================================-->
        <form class="form-horizontal" action="{{ route('testimonials.update', $review->id) }}" method="POST" enctype="multipart/form-data">
            <input name="_method" type="hidden" value="PUT">
        	@csrf
            <div class="panel-body">

                @if(isset($review->photo))
                    <div class="form-group">
                        <div class="widget-image-box text-center">
                            <img loading="lazy" style="max-width: 100% !important;" src="{{ my_asset($review->photo) }}" alt="Image">
                        </div>
                    </div>
                @endif
                <div class="form-group">
                    <label class="col-sm-2 control-label" for="photo">{{translate('Photo')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="file" id="photo" name="photo" class="form-control">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="name">{{translate('Link')}} </label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Link')}}" id="name" name="name" class="form-control" value="{{ $review->name }}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-2 control-label" for="classes">{{translate('Classes')}} <span class="red">*</span></label>
                    <div class="col-sm-10">
                        <input type="text" placeholder="{{translate('Classes')}}" id="classes" name="classes" class="form-control" required value="{{ $review->classes }}">
                    </div>
                </div>

            </div>
            <div class="panel-footer text-right">
                <button class="btn btn-success" type="submit">{{translate('Save')}}</button>
                <a href="{{ route('testimonials.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
            </div>
        </form>
        <!--===================================================-->
        <!--End Horizontal Form-->

    </div>
</div>

@endsection
