@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <h3 class="panel-title text-center">{{translate('Testimonial Section')}}</h3>
            </div>
            <div class="panel-body">
                <form class="form-horizontal" action="{{ route('testimonials_section.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="testi_title">{{translate('Title')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Title')}}" id="testi_title" name="testi_title" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'testi_title')->first()->value }}">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="testi_bg_color">{{translate('Background Color')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Background Color')}}" id="testi_bg_color" name="testi_bg_color" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'testi_bg_color')->first()->value }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="testi_color">{{translate('Text Color')}} <span class="red">*</span></label>
                        <div class="col-sm-10">
                            <input type="text" placeholder="{{translate('Text Color')}}" id="testi_color" name="testi_color" class="form-control" required value="{{ \App\BusinessSetting::where('type', 'testi_color')->first()->value }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-12 text-right">
                            <button class="btn btn-purple" type="submit">{{translate('Save')}}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <a href="{{ route('testimonials.create')}}" class="btn btn-rounded btn-info pull-right">{{translate('Add New Testimonials')}}</a>
    </div>
</div>

<br>

<!-- Basic Data Tables -->
<!--===================================================-->
<div class="panel pad-btm-34">
    <div class="panel-heading bord-btm clearfix pad-all h-100">
        <h3 class="panel-title pull-left pad-no">{{translate('Testimonials')}}</h3>
    </div>
    <div class="panel-body">
        <table class="table table-striped table-bordered demo-dt-basic" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>{{translate('Image')}}</th>
                    <th>{{translate('Link')}}</th>
                    <th>{{translate('Published')}}</th>
                    <th width="10%">{{translate('Options')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($reviews as $key => $review)
                    <tr>
                        <td>{{$key+1}}</td>
                        <td>
                            @if(isset($review->photo))
                                <div class="media-left">
                                    <img loading="lazy"  class="img-md" src="{{ my_asset($review->photo)}}" alt="Image">
                                </div>
                            @else
                                N/A
                            @endif
                        </td>
                        <td>{{ $review->name }}</td>
                        <td><label class="switch">
                            <input onchange="update_published(this)" value="{{ $review->id }}" type="checkbox" <?php if($review->published == 1) echo "checked";?> >
                            <span class="slider round"></span></label>
                        </td>
                        <td class="text-center">
                            <a class="btn btn-success" href="{{route('testimonials.edit', encrypt($review->id))}}">{{ translate('Edit') }}</a>
                            <a class="btn btn-danger" onclick="confirm_modal('{{route('testimonials.destroy', $review->id)}}');">{{ translate('Delete') }}</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@endsection

@section('script')
    <script type="text/javascript">

        function update_published(el){
            if(el.checked){
                var published = 1;
            } else {
                var published = 0;
            }
            $.post('{{ route('testimonials.published') }}', {_token:'{{ csrf_token() }}', id:el.value, published:published}, function(data){
                if(data == 1){
                    showAlert('success', 'Published testimonials updated successfully');
                }
                else{
                    showAlert('danger', 'Something went wrong');
                }
            });
        }
        function filter_by_rating(el){
            var rating = $('#rating').val();
            if (rating != '') {
                $('#sort_by_rating').submit();
            }
        }
    </script>
@endsection
