@extends('layouts.app')

@section('content')
    <div class="panel">
        <div class="panel-body">
            <div class="row">
                <div class="col-lg-12">
                    <div class="p-4 bg-white shadow-sm">
                        <div class="row pb-4">
                            <div class="col-lg-12 text-center">
                                <h3 class="heading-2 strong-700 mb-0 mt-2">
                                    {{ translate('Feedcack / Reviews') }}
                                </h3>
                            </div>
                        </div>
                        <form class="form-default">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="" class="text-uppercase c-gray-light">{{ translate('Full Name')}}</label>
                                        <input type="text" name="name" value="{{ $reviews->name }}" class="form-control" disabled>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="" class="text-uppercase c-gray-light">{{ translate('Company')}}</label>
                                        <input type="text" name="email" value="{{ $reviews->company }}" class="form-control" disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <label for="" class="text-uppercase c-gray-light">{{ translate('Review Rate')}}</label>
                                    <div class="rating clearfix d-block">
                                        <span class="star-rating star-rating-sm">
                                            @for ($i=0; $i < $reviews->rating; $i++)
                                                <i class="fa fa-star active"></i>
                                            @endfor
                                            @for ($i=0; $i < 5-$reviews->rating; $i++)
                                                <i class="fa fa-star"></i>
                                            @endfor
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3">
                                @if ($reviews->photo != null)
                                <div class="col-lg-12 form-group">
                                    <div class="form-group">
                                        <div class="col-lg-7" style="padding-left: 0px; padding-top: 10px;">
                                            <label for="" class="text-uppercase c-gray-light">{{ translate('Photo Uploaded')}}</label>
                                            <div id="photos">
                                                <div class="col-md-6 col-sm-6 col-xs-6">
                                                    <div class="img-upload-preview">
                                                        <img loading="lazy" onclick="window.open(this.src)" src="{{ my_asset($reviews->photo) }}" alt="" class="img-responsive">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif
                                <div class="col-sm-12">
                                    <label for="" class="text-uppercase c-gray-light">{{ translate('Comment')}}</label>
                                    <textarea class="form-control" rows="4" name="comment" placeholder="{{ translate('Your review')}}" disabled>{{ $reviews->comment }}</textarea>
                                </div>
                            </div>
                            <div class="panel-footer text-right">
                                <a href="{{ route('reviews.index') }}" name="buttonBack" class="btn btn-danger">{{ translate('Back') }}</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection