<?php

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/admin', 'HomeController@admin_dashboard')->name('admin.dashboard')->middleware(['auth', 'admin']);
Route::group(['prefix' =>'admin', 'middleware' => ['auth', 'admin']], function(){

	Route::get('/sliders', 'SliderController@index')->name('sliders.index');
	Route::get('/sliders/create','SliderController@create')->name('sliders.create');
	Route::post('/sliders/store','SliderController@store')->name('sliders.store');
	Route::get('/sliders/edit/{step}','SliderController@edit')->name('sliders.edit');
	Route::put('/sliders/update/{id}','SliderController@update')->name('sliders.update');
	Route::get('/sliders/destroy/{id}', 'SliderController@destroy')->name('sliders.destroy');
	Route::post('/sliders/published', 'SliderController@updatePublished')->name('sliders.published');
	Route::post('/slider-section-update', 'SliderController@slider_section_update')->name('slider_section.update');

	Route::get('/statistics', 'BusinessSettingsController@statistics')->name('statistics.index');
	Route::post('/statistics-update', 'BusinessSettingsController@statistics_update')->name('statistics.update');

	Route::get('/downloadable-section', 'BusinessSettingsController@downloadables')->name('downloadable_section.index');
	Route::post('/downloadable-section-update', 'BusinessSettingsController@downloadables_update')->name('downloadable_section.update');

	Route::get('/last-conference-section', 'BusinessSettingsController@last_conference_section')->name('last_conference_section.index');
	Route::post('/last-conference-section-update', 'BusinessSettingsController@last_conference_section_update')->name('last_conference_section.update');

	Route::get('/hotel-section', 'BusinessSettingsController@hotel_section')->name('hotel_section.index');
	Route::get('/hotel-page', 'BusinessSettingsController@hotel_page')->name('hotel_page.index');
	Route::post('/hotel-section-update', 'BusinessSettingsController@hotel_section_update')->name('hotel_section.update');

	Route::get('/agendas', 'AgendaController@index')->name('agendas.index');
	Route::get('/agendas/create','AgendaController@create')->name('agendas.create');
	Route::post('/agendas/store','AgendaController@store')->name('agendas.store');
	Route::get('/agendas/edit/{step}','AgendaController@edit')->name('agendas.edit');
	Route::put('/agendas/update/{id}','AgendaController@update')->name('agendas.update');
	Route::get('/agendas/destroy/{id}', 'AgendaController@destroy')->name('agendas.destroy');

	Route::get('/agenda-events/create/{id}','AgendaDetailsController@create')->name('agenda_details.create');
	Route::post('/agenda-events/store','AgendaDetailsController@store')->name('agenda_details.store');
	Route::get('/agenda-events/edit/{step}','AgendaDetailsController@edit')->name('agenda_details.edit');
	Route::put('/agenda-events/update/{id}','AgendaDetailsController@update')->name('agenda_details.update');
	Route::get('/agenda-events/destroy/{id}', 'AgendaDetailsController@destroy')->name('agenda_details.destroy');

	Route::get('/director-section', 'BusinessSettingsController@director_section')->name('director_section.index');
	Route::post('/director-section-update', 'BusinessSettingsController@director_section_update')->name('director_section.update');


	// start commons

	Route::get('/commons-secure-pass', 'BusinessSettingsController@commons_secure_pass')->name('commons_secure_pass.index');
	Route::post('/commons-secure-pass-update', 'BusinessSettingsController@common_secure_pass_update')->name('commons_secure_pass.update');

	Route::get('/commons-sponsor', 'BusinessSettingsController@commons_sponsor')->name('commons_sponsor.index');
	Route::post('/commons-sponsor-update', 'BusinessSettingsController@common_sponsor_update')->name('commons_sponsor.update');

	Route::get('/newsletter', 'BusinessSettingsController@commons_newsletter')->name('commons_newsletter.index');
	Route::post('/newsletter-update', 'BusinessSettingsController@common_newsletter_update')->name('commons_newsletter.update');

	// end commons

	Route::get('/banners', 'BusinessSettingsController@banners')->name('banners.index');
	Route::post('/banners-update', 'BusinessSettingsController@banners_update')->name('banners.update');

	Route::get('/meeting-costs', 'MeetingCostController@index')->name('meeting_costs.index');
	Route::get('/meeting-costs/create','MeetingCostController@create')->name('meeting_costs.create');
	Route::post('/meeting-costs/store','MeetingCostController@store')->name('meeting_costs.store');
	Route::get('/meeting-costs/edit/{step}','MeetingCostController@edit')->name('meeting_costs.edit');
	Route::put('/meeting-costs/update/{id}','MeetingCostController@update')->name('meeting_costs.update');
	Route::get('/meeting-costs/destroy/{id}', 'MeetingCostController@destroy')->name('meeting_costs.destroy');
	Route::post('/meeting-costs/is-vip', 'MeetingCostController@isVip')->name('meeting_costs.is_vip');
	Route::post('/meeting-costs/is-sold-out', 'MeetingCostController@isSoldOut')->name('meeting_costs.is_sold_out');

	Route::get('/meeting-scheduler', 'BusinessSettingsController@meeting_scheduler')->name('meeting_scheduler.index');
	Route::post('/meeting-scheduler-update', 'BusinessSettingsController@meeting_scheduler_update')->name('meeting_scheduler.update');

	Route::post('/about-us-update', 'BusinessSettingsController@about_us_update')->name('about_us.update');

	Route::get('/visa', 'BusinessSettingsController@visa')->name('visa.index');

	Route::get('/covid-info', 'BusinessSettingsController@covid_info')->name('covid_info.index');

	Route::get('/about-location', 'BusinessSettingsController@about_location')->name('about_location.index');

	Route::get('/about-dubai', 'BusinessSettingsController@about_dubai')->name('about_dubai.index');

	Route::get('/contact-us', 'BusinessSettingsController@contact_us')->name('contact_us.index');


	Route::get('/countdown-section', 'BusinessSettingsController@countdown_section')->name('countdown_section.index');
	Route::post('/countdown-section-update', 'BusinessSettingsController@countdown_section_update')->name('countdown_section.update');

	Route::get('/registration-section', 'BusinessSettingsController@registration_section')->name('registration_section.index');
	Route::post('/registration-section-update', 'BusinessSettingsController@registration_section_update')->name('registration_section.update');

	Route::get('/agenda-section', 'BusinessSettingsController@agenda_section')->name('agenda_section.index');
	Route::post('/agenda-section-update', 'BusinessSettingsController@agenda_section_update')->name('agenda_section.update');

	Route::get('/sponsorships', 'SponsorshipController@index')->name('sponsorships.index');
	Route::get('/sponsorships/create','SponsorshipController@create')->name('sponsorships.create');
	Route::post('/sponsorships/store','SponsorshipController@store')->name('sponsorships.store');
	Route::get('/sponsorships/edit/{step}','SponsorshipController@edit')->name('sponsorships.edit');
	Route::put('/sponsorships/update/{id}','SponsorshipController@update')->name('sponsorships.update');
	Route::get('/sponsorships/destroy/{id}', 'SponsorshipController@destroy')->name('sponsorships.destroy');
	Route::post('/sponsorships/is-published', 'SponsorshipController@published')->name('sponsorships.published');
	Route::post('/sponsorships/is-sold-out', 'SponsorshipController@sold_out')->name('sponsorships.sold_out');

	Route::get('/neutralities', 'NeutralityController@index')->name('neutralities.index');
	Route::get('/neutralities/create','NeutralityController@create')->name('neutralities.create');
	Route::post('/neutralities/store','NeutralityController@store')->name('neutralities.store');
	Route::get('/neutralities/edit/{step}','NeutralityController@edit')->name('neutralities.edit');
	Route::put('/neutralities/update/{id}','NeutralityController@update')->name('neutralities.update');
	Route::get('/neutralities/destroy/{id}', 'NeutralityController@destroy')->name('neutralities.destroy');
	Route::post('/neutralities/is-published', 'NeutralityController@published')->name('neutralities.published');

	Route::get('/specializations', 'SpecializationController@index')->name('specializations.index');
	Route::get('/specializations/create','SpecializationController@create')->name('specializations.create');
	Route::post('/specializations/store','SpecializationController@store')->name('specializations.store');
	Route::get('/specializations/edit/{step}','SpecializationController@edit')->name('specializations.edit');
	Route::put('/specializations/update/{id}','SpecializationController@update')->name('specializations.update');
	Route::get('/specializations/destroy/{id}', 'SpecializationController@destroy')->name('specializations.destroy');
	Route::post('/specializations/is-published', 'SpecializationController@published')->name('specializations.published');

	Route::get('/services', 'ServiceController@index')->name('services.index');
	Route::get('/services/create','ServiceController@create')->name('services.create');
	Route::post('/services/store','ServiceController@store')->name('services.store');
	Route::get('/services/edit/{step}','ServiceController@edit')->name('services.edit');
	Route::put('/services/update/{id}','ServiceController@update')->name('services.update');
	Route::get('/services/destroy/{id}', 'ServiceController@destroy')->name('services.destroy');
	Route::post('/services/is-published', 'ServiceController@published')->name('services.published');

	Route::get('/softwares', 'SoftwareController@index')->name('softwares.index');
	Route::get('/softwares/create','SoftwareController@create')->name('softwares.create');
	Route::post('/softwares/store','SoftwareController@store')->name('softwares.store');
	Route::get('/softwares/edit/{step}','SoftwareController@edit')->name('softwares.edit');
	Route::put('/softwares/update/{id}','SoftwareController@update')->name('softwares.update');
	Route::get('/softwares/destroy/{id}', 'SoftwareController@destroy')->name('softwares.destroy');
	Route::post('/softwares/is-published', 'SoftwareController@published')->name('softwares.published');

	Route::get('/advertisements', 'AdvertisementController@index')->name('advertisements.index');
	Route::get('/advertisements/create','AdvertisementController@create')->name('advertisements.create');
	Route::post('/advertisements/store','AdvertisementController@store')->name('advertisements.store');
	Route::get('/advertisements/edit/{step}','AdvertisementController@edit')->name('advertisements.edit');
	Route::put('/advertisements/update/{id}','AdvertisementController@update')->name('advertisements.update');
	Route::get('/advertisements/destroy/{id}', 'AdvertisementController@destroy')->name('advertisements.destroy');
	Route::post('/advertisements/is-published', 'AdvertisementController@published')->name('advertisements.published');

	Route::get('/dietaries', 'DietaryController@index')->name('dietaries.index');
	Route::get('/dietaries/create','DietaryController@create')->name('dietaries.create');
	Route::post('/dietaries/store','DietaryController@store')->name('dietaries.store');
	Route::get('/dietaries/edit/{step}','DietaryController@edit')->name('dietaries.edit');
	Route::put('/dietaries/update/{id}','DietaryController@update')->name('dietaries.update');
	Route::get('/dietaries/destroy/{id}', 'DietaryController@destroy')->name('dietaries.destroy');
	Route::post('/dietaries/is-published', 'DietaryController@published')->name('dietaries.published');

	Route::get('/emails', 'BusinessSettingsController@inquiry')->name('inquiry.index');
	Route::get('/emails/view/{step}','BusinessSettingsController@inquiry_view')->name('inquiry.view');

	Route::get('/aftermovie-section', 'BusinessSettingsController@aftermovie_section')->name('aftermovie_section.index');
	Route::post('/aftermovie-section-update', 'BusinessSettingsController@aftermovie_section_update')->name('aftermovie_section.update');

	Route::get('/benefits', 'BenefitController@index')->name('benefits.index');
	Route::get('/benefits/create','BenefitController@create')->name('benefits.create');
	Route::post('/benefits/store','BenefitController@store')->name('benefits.store');
	Route::get('/benefits/edit/{step}','BenefitController@edit')->name('benefits.edit');
	Route::put('/benefits/update/{id}','BenefitController@update')->name('benefits.update');
	Route::get('/benefits/destroy/{id}', 'BenefitController@destroy')->name('benefits.destroy');
	Route::post('/benefits/is-published', 'BenefitController@published')->name('benefits.published');

	Route::get('/sponsors', 'SponsorPerSponsoshipPackageController@index')->name('sponsors.index');
	Route::get('/sponsors/create','SponsorPerSponsoshipPackageController@create')->name('sponsors.create');
	Route::post('/sponsors/store','SponsorPerSponsoshipPackageController@store')->name('sponsors.store');
	Route::get('/sponsors/edit/{step}','SponsorPerSponsoshipPackageController@edit')->name('sponsors.edit');
	Route::put('/sponsors/update/{id}','SponsorPerSponsoshipPackageController@update')->name('sponsors.update');
	Route::get('/sponsors/destroy/{id}', 'SponsorPerSponsoshipPackageController@destroy')->name('sponsors.destroy');
	
	Route::get('/registrants', 'BusinessSettingsController@registrationsList')->name('registrations.index');
	Route::get('/registrants/view/{step}','BusinessSettingsController@registrationsView')->name('registrations.view');

	Route::resource('profile','ProfileController');

	Route::post('/business-settings/update', 'BusinessSettingsController@update')->name('business_settings.update');
	Route::post('/business-settings/update/activation', 'BusinessSettingsController@updateActivationSettings')->name('business_settings.update.activation');
	Route::get('/activation', 'BusinessSettingsController@activation')->name('activation.index');
	Route::get('/smtp-settings', 'BusinessSettingsController@smtp_settings')->name('smtp_settings.index');
	Route::post('/env_key_update', 'BusinessSettingsController@env_key_update')->name('env_key_update.update');
	Route::post('/smtpSettings', 'BusinessSettingsController@smtpSettings')->name('smtpSettings.update');

	Route::get('/google-recaptcha', 'BusinessSettingsController@google_recaptcha')->name('google_recaptcha.index');
	Route::post('/google-recaptcha-update', 'BusinessSettingsController@google_recaptcha_update')->name('google_recaptcha.update');

	Route::get('/cache', 'HomeController@cache')->name('cache.index');
	Route::post('/cache/website', 'HomeController@cache_website')->name('cache.website');

	Route::resource('roles','RoleController');
    Route::get('/roles/destroy/{id}', 'RoleController@destroy')->name('roles.destroy');

    Route::resource('staffs','StaffController');
    Route::get('/staffs/destroy/{id}', 'StaffController@destroy')->name('staffs.destroy');

	Route::resource('generalsettings','GeneralSettingController');
	Route::get('/logo','GeneralSettingController@logo')->name('generalsettings.logo');
	Route::post('/logo','GeneralSettingController@storeLogo')->name('generalsettings.logo.store');

	Route::resource('seosetting','SEOController');

	Route::get('/custom-css', 'BusinessSettingsController@custom_css')->name('custom_css.index');
	Route::post('/custom-css-update', 'BusinessSettingsController@custom_css_update')->name('custom_css.update');

	Route::get('/end-of-registration', 'BusinessSettingsController@end_of_reg')->name('end_of_reg.index');
	Route::post('/end-of-registration-update', 'BusinessSettingsController@end_of_reg_update')->name('end_of_reg.update');

	Route::get('/facebook-chat', 'BusinessSettingsController@facebook_chat')->name('facebook_chat.index');
	Route::post('/facebook-chat-update', 'BusinessSettingsController@facebook_chat_update')->name('facebook_chat.update');
});
