<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link name="favicon" type="image/x-icon" href="<?php echo e(my_asset(\App\GeneralSetting::first()->favicon)); ?>" rel="shortcut icon" />

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet" type="text/css">

    <!--Bootstrap Stylesheet [ REQUIRED ]-->
    <link href="<?php echo e(my_asset('css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!--Font Awesome [ OPTIONAL ]-->
    <link href="<?php echo e(my_asset('plugins/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">

    <!--rahuyo Stylesheet [ REQUIRED ]-->
    <link href="<?php echo e(my_asset('css/rahuyo.min.css')); ?>" rel="stylesheet">

    <!--rahuyo Premium Icon [ DEMONSTRATION ]-->
    <link href="<?php echo e(my_asset('css/demo/rahuyo-icons.min.css')); ?>" rel="stylesheet">

    <!--Demo [ DEMONSTRATION ]-->
    <link href="<?php echo e(my_asset('css/demo/rahuyo-demo.min.css')); ?>" rel="stylesheet">

    <!--Theme [ DEMONSTRATION ]-->
    <link href="<?php echo e(my_asset('css/themes/type-c/theme-navy.min.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(my_asset('css/custom.css')); ?>" rel="stylesheet">

</head>
<body>
    <?php
        $generalsetting = \App\GeneralSetting::first();
    ?>
    <div id="container" class="blank-index"
        <?php if($generalsetting->admin_login_background != null): ?>
            style="background-image:url('<?php echo e(my_asset($generalsetting->admin_login_background)); ?>');"
        <?php else: ?>
            style="background-image:url('<?php echo e(my_asset('img/bg-img/login-bg.jpg')); ?>');"
        <?php endif; ?>>
        <div class="cls-content">
            <div class="container">
                <div class="row">
                    <!-- <div class="col-md-10 col-md-offset-1">
                        <div class="panel">
                            <div class="panel-body pad-no"> -->
                                <?php echo $__env->yieldContent('content'); ?>
                            <!-- </div>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
    </div>

    <!--JAVASCRIPT-->
    <!--=================================================-->

    <!--jQuery [ REQUIRED ]-->
    <script src=" <?php echo e(my_asset('js/jquery.min.js')); ?>"></script>


    <!--BootstrapJS [ RECOMMENDED ]-->
    <script src="<?php echo e(my_asset('js/bootstrap.min.js')); ?>"></script>


    <!--rahuyo [ RECOMMENDED ]-->
    <script src="<?php echo e(my_asset('js/rahuyo.min.js')); ?>"></script>

    <!--Alerts [ SAMPLE ]-->
    <script src="<?php echo e(my_asset('js/demo/ui-alerts.js')); ?>"></script>

    <?php echo $__env->yieldContent('script'); ?>

</body>
</html>
<?php /**PATH /home/clnupdates/rwexpos.clnupdates.com/rw-regs/2024/resources/views/layouts/login.blade.php ENDPATH**/ ?>