<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms\Business\Brand;

use Twilio\ListResource;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class BrandedChannelList extends ListResource {
    /**
     * Construct the BrandedChannelList
     *
     * @param Version $version Version that contains the resource
     * @param string $businessSid Business Sid.
     * @param string $brandSid Brand Sid.
     */
    public function __construct(Version $version, string $businessSid, string $brandSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['businessSid' => $businessSid, 'brandSid' => $brandSid, ];
    }

    /**
     * Constructs a BrandedChannelContext
     *
     * @param string $sid Branded Channel Sid.
     */
    public function getContext(string $sid): BrandedChannelContext {
        return new BrandedChannelContext(
            $this->version,
            $this->solution['businessSid'],
            $this->solution['brandSid'],
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Preview.TrustedComms.BrandedChannelList]';
    }
}