<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Supersim\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class NetworkOptions {
    /**
     * @param string $isoCountry The ISO country code of the Network resources to
     *                           read
     * @param string $mcc The MCC of Network resource identifiers to be read
     * @param string $mnc The MNC of Network resource identifiers to be read
     * @return ReadNetworkOptions Options builder
     */
    public static function read(string $isoCountry = Values::NONE, string $mcc = Values::NONE, string $mnc = Values::NONE): ReadNetworkOptions {
        return new ReadNetworkOptions($isoCountry, $mcc, $mnc);
    }
}

class ReadNetworkOptions extends Options {
    /**
     * @param string $isoCountry The ISO country code of the Network resources to
     *                           read
     * @param string $mcc The MCC of Network resource identifiers to be read
     * @param string $mnc The MNC of Network resource identifiers to be read
     */
    public function __construct(string $isoCountry = Values::NONE, string $mcc = Values::NONE, string $mnc = Values::NONE) {
        $this->options['isoCountry'] = $isoCountry;
        $this->options['mcc'] = $mcc;
        $this->options['mnc'] = $mnc;
    }

    /**
     * The [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the Network resources to read.
     *
     * @param string $isoCountry The ISO country code of the Network resources to
     *                           read
     * @return $this Fluent Builder
     */
    public function setIsoCountry(string $isoCountry): self {
        $this->options['isoCountry'] = $isoCountry;
        return $this;
    }

    /**
     * The 'mobile country code' of a country. Network resources with this `mcc` in their `identifiers` will be read.
     *
     * @param string $mcc The MCC of Network resource identifiers to be read
     * @return $this Fluent Builder
     */
    public function setMcc(string $mcc): self {
        $this->options['mcc'] = $mcc;
        return $this;
    }

    /**
     * The 'mobile network code' of a mobile operator network. Network resources with this `mnc` in their `identifiers` will be read.
     *
     * @param string $mnc The MNC of Network resource identifiers to be read
     * @return $this Fluent Builder
     */
    public function setMnc(string $mnc): self {
        $this->options['mnc'] = $mnc;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Supersim.V1.ReadNetworkOptions ' . $options . ']';
    }
}